<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderInvoice extends Eloquent {

	protected $table = 'order_invoices';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function order()
	{
		return $this->belongsTo('App\Models\Order');
	}

	public function resturant()
	{
		return $this->belongsTo('App\Models\Resturant');
	}

}