<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->morphs('user');
			$table->enum('type', array('test'));
			$table->string('title');
			$table->text('description');
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}