<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->integer('category_id');
			$table->double('supplier_profit');
			$table->double('marketer_profit');
			$table->double('system_profit');
			$table->text('description');
			$table->string('barcode');
			$table->string('video_url')->nullable();
			$table->enum('status', array('test'));
			$table->string('code');
			$table->boolean('is_private')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}