<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->morphs('user');
			$table->double('amount');
			$table->enum('status', array('expected', 'available', 'cancel', 'done'));
			$table->integer('order_id');
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}