<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('egroup_id')->references('id')->on('egroups')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('egroups', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('marketers', function(Blueprint $table) {
			$table->foreign('payment_method_id')->references('id')->on('payment_methods')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('marketers', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('governorates', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('governorate_id')->references('id')->on('governorates')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('warehouses', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('shipping_companies', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('payment_request', function(Blueprint $table) {
			$table->foreign('transaction_id')->references('id')->on('transactions')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cms', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_plan_id_foreign');
		});
		Schema::table('companies', function(Blueprint $table) {
			$table->dropForeign('companies_country_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_egroup_id_foreign');
		});
		Schema::table('egroups', function(Blueprint $table) {
			$table->dropForeign('egroups_company_id_foreign');
		});
		Schema::table('marketers', function(Blueprint $table) {
			$table->dropForeign('marketers_payment_method_id_foreign');
		});
		Schema::table('marketers', function(Blueprint $table) {
			$table->dropForeign('marketers_city_id_foreign');
		});
		Schema::table('governorates', function(Blueprint $table) {
			$table->dropForeign('governorates_country_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_governorate_id_foreign');
		});
		Schema::table('warehouses', function(Blueprint $table) {
			$table->dropForeign('warehouses_city_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_company_id_foreign');
		});
		Schema::table('shipping_companies', function(Blueprint $table) {
			$table->dropForeign('shipping_companies_company_id_foreign');
		});
		Schema::table('payment_request', function(Blueprint $table) {
			$table->dropForeign('payment_request_transaction_id_foreign');
		});
		Schema::table('contacts', function(Blueprint $table) {
			$table->dropForeign('contacts_company_id_foreign');
		});
		Schema::table('cms', function(Blueprint $table) {
			$table->dropForeign('cms_company_id_foreign');
		});
	}
}