<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('customer_id')->unsigned();
			$table->bigInteger('subscription_id')->unsigned()->nullable();
			$table->datetime('next_payment_at')->nullable();
			$table->bigInteger('amount');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}