<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->nullable();
			$table->string('email')->nullable();
			$table->string('phone')->nullable();
			$table->string('address')->nullable();
			$table->string('image')->nullable();
			$table->tinyInteger('block')->default('0');
			$table->string('facebook_id')->nullable();
			$table->string('google_id')->nullable();
			$table->bigInteger('country_id')->nullable();
			$table->bigInteger('city_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}