<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('roles_has_permissions', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('roles_has_permissions', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_company_role', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_company_role', function(Blueprint $table) {
			$table->foreign('company_id')->references('id')->on('companies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_company_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('roles_has_permissions', function(Blueprint $table) {
			$table->dropForeign('roles_has_permissions_role_id_foreign');
		});
		Schema::table('roles_has_permissions', function(Blueprint $table) {
			$table->dropForeign('roles_has_permissions_permission_id_foreign');
		});
		Schema::table('user_company_role', function(Blueprint $table) {
			$table->dropForeign('user_company_role_user_id_foreign');
		});
		Schema::table('user_company_role', function(Blueprint $table) {
			$table->dropForeign('user_company_role_company_id_foreign');
		});
		Schema::table('user_company_role', function(Blueprint $table) {
			$table->dropForeign('user_company_role_role_id_foreign');
		});
	}
}