<?php

namespace App\Models;

class Restaurant extends Eloquent {

	protected $table = 'restaurants';
	public $timestamps = true;
	protected $fillable = array('name', 'email', 'phone', 'password', 'is_opened', 'neighborhood_id', 'minimum_charge', 'delivery_price', 'contact_phone', 'contact_whatsapp');
	protected $hidden = array('password', 'api_token', 'pin_code');

	public function neighborhood()
	{
		return $this->belongsTo('App\Models\Neighborhood');
	}

	public function offers()
	{
		return $this->hasMany('App\Models\Offer');
	}

	public function orders()
	{
		return $this->hasMany('App\Models\Order');
	}

	public function meals()
	{
		return $this->hasMany('App\Models\Meal');
	}

	public function payments()
	{
		return $this->hasMany('App\Models\Payment');
	}

	public function reviews()
	{
		return $this->hasMany('App\Models\Review');
	}

	public function categories()
	{
		return $this->belongsToMany('App\Models\Category');
	}

	public function notifications()
	{
		return $this->morphMany('App\Models\Notification', 'notificationable');
	}

	public function tokens()
	{
		return $this->morphMany('App\Models\Token', 'tokenable');
	}

}