<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRelativeInfosTable extends Migration {

	public function up()
	{
		Schema::create('relative_infos', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->string('relative_name', 299);
			$table->string('relative_email', 299)->nullable();
			$table->date('relative_dob')->nullable();
			$table->integer('relation')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('relative_infos');
	}
}