<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIntegrationProviderCustomizationsTable extends Migration {

	public function up()
	{
		Schema::create('integration_provider_customizations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->json('auth_credentials')->nullable();
			$table->enum('status', array('pending', 'successful', 'error'));
			$table->integer('created_by');
			$table->integer('center_id')->nullable();
			$table->datetime('date_test_connection')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('integration_provider_customizations');
	}
}