<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('slack_id', 255);
			$table->string('red_pill_link', 255);
			$table->enum('type', array('otp', 'adhoc', 'retainer'));
			$table->enum('status', array('active', 'closed', 'archived'));
			$table->integer('pm_id')->unsigned();
			$table->integer('dm_id')->unsigned();
			$table->string('created_by');
			$table->string('updated_by', 255);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}