<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('allocations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('allocations', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('pm_id')->references('id')->on('user')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('dm_id')->references('id')->on('user')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('user', function(Blueprint $table) {
			$table->dropForeign('user_department_id_foreign');
		});
		Schema::table('user', function(Blueprint $table) {
			$table->dropForeign('user_role_id_foreign');
		});
		Schema::table('allocations', function(Blueprint $table) {
			$table->dropForeign('allocations_user_id_foreign');
		});
		Schema::table('allocations', function(Blueprint $table) {
			$table->dropForeign('allocations_project_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_pm_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_dm_id_foreign');
		});
	}
}