<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('identifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rounds', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('games')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rounds', function(Blueprint $table) {
			$table->foreign('world_id')->references('id')->on('worlds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rounds', function(Blueprint $table) {
			$table->foreign('fighter_id')->references('id')->on('fighters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('characters', function(Blueprint $table) {
			$table->foreign('world_id')->references('id')->on('worlds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fighters', function(Blueprint $table) {
			$table->foreign('game_id')->references('id')->on('games')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fighters', function(Blueprint $table) {
			$table->foreign('character_id')->references('id')->on('characters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('fighters', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('moves', function(Blueprint $table) {
			$table->foreign('action_id')->references('id')->on('actions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('moves', function(Blueprint $table) {
			$table->foreign('fighter_id')->references('id')->on('fighters')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('moves', function(Blueprint $table) {
			$table->foreign('round_id')->references('id')->on('rounds')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('identifications', function(Blueprint $table) {
			$table->dropForeign('identifications_user_id_foreign');
		});
		Schema::table('rounds', function(Blueprint $table) {
			$table->dropForeign('rounds_game_id_foreign');
		});
		Schema::table('rounds', function(Blueprint $table) {
			$table->dropForeign('rounds_world_id_foreign');
		});
		Schema::table('rounds', function(Blueprint $table) {
			$table->dropForeign('rounds_fighter_id_foreign');
		});
		Schema::table('characters', function(Blueprint $table) {
			$table->dropForeign('characters_world_id_foreign');
		});
		Schema::table('fighters', function(Blueprint $table) {
			$table->dropForeign('fighters_game_id_foreign');
		});
		Schema::table('fighters', function(Blueprint $table) {
			$table->dropForeign('fighters_character_id_foreign');
		});
		Schema::table('fighters', function(Blueprint $table) {
			$table->dropForeign('fighters_user_id_foreign');
		});
		Schema::table('moves', function(Blueprint $table) {
			$table->dropForeign('moves_action_id_foreign');
		});
		Schema::table('moves', function(Blueprint $table) {
			$table->dropForeign('moves_fighter_id_foreign');
		});
		Schema::table('moves', function(Blueprint $table) {
			$table->dropForeign('moves_round_id_foreign');
		});
	}
}