<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBoxesTable extends Migration {

	public function up()
	{
		Schema::create('boxes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('agency_id')->unsigned()->nullable();
			$table->string('slug')->nullable();
			$table->string('name', 255)->nullable();
			$table->string('alert_threshold')->nullable()->default('0');
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('boxes');
	}
}