<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCashStatementsTable extends Migration {

	public function up()
	{
		Schema::create('cash_statements', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_box_id')->unsigned()->nullable();
			$table->integer('admin_id')->unsigned()->nullable();
			$table->integer('end_id')->unsigned()->nullable();
			$table->integer('auditor_user_id')->unsigned()->nullable();
			$table->integer('sender_user_id')->unsigned()->nullable();
			$table->integer('beneficiary_user_id')->unsigned()->nullable();
			$table->string('slug')->nullable();
			$table->integer('uv')->nullable();
			$table->string('type')->nullable();
			$table->timestamp('date')->nullable();
			$table->string('open_to', 225)->nullable();
			$table->string('start', 10)->nullable()->default('0');
			$table->string('end', 10)->nullable()->default('0');
			$table->text('audit_comment')->nullable();
			$table->string('audit_status', 10)->nullable()->default('0');
			$table->string('rejet', 10)->nullable()->default('0');
			$table->text('rejet_description')->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('cash_statements');
	}
}