<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConfigsTable extends Migration {

	public function up()
	{
		Schema::create('configs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('default_currency_id')->unsigned()->nullable();
			$table->integer('default_country_id')->unsigned()->nullable();
			$table->string('slug')->nullable();
			$table->string('uv')->nullable();
			$table->string('tva')->nullable();
			$table->string('cash')->nullable();
			$table->text('transfer_send_valid_message')->nullable();
			$table->text('transfer_send_end_message')->nullable();
			$table->text('exchange_send_valid_message')->nullable();
			$table->text('exchange_send_end_message')->nullable();
			$table->string('default_box_alert_threshold')->nullable()->default('0');
			$table->string('default_agency_alert_threshold')->nullable();
			$table->time('default_open_hour')->nullable();
			$table->time('default_close_hour')->nullable();
			$table->string('status', 10)->nullable()->default('0');
			$table->string('use_mobile_pay', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('configs');
	}
}