<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReloadsUvTable extends Migration {

	public function up()
	{
		Schema::create('reloads_uv', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('users_id')->unsigned()->nullable();
			$table->integer('agency_id')->unsigned()->nullable();
			$table->integer('partner_id')->unsigned()->nullable();
			$table->integer('users_box_id')->unsigned()->nullable();
			$table->integer('reloader_id')->unsigned();
			$table->string('slug')->nullable();
			$table->string('amount')->nullable();
			$table->string('type', 10)->nullable()->default('0');
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('reloads_uv');
	}
}