<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersBoxTable extends Migration {

	public function up()
	{
		Schema::create('users_box', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('box_id')->unsigned()->nullable();
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('slug')->nullable();
			$table->timestamp('start_date')->nullable();
			$table->timestamp('end_date')->nullable();
			$table->string('commission')->nullable()->default('0');
			$table->string('cash')->nullable()->default('0');
			$table->string('uv')->nullable()->default('0');
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('users_box');
	}
}