<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('job_id')->unsigned()->nullable();
			$table->integer('agency_id')->unsigned()->nullable();
			$table->string('slug');
			$table->string('registe_number', 255)->nullable();
			$table->string('name', 255)->nullable();
			$table->string('uv')->nullable()->default('0');
			$table->string('phone', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('password')->nullable();
			$table->string('remember_token')->nullable();
			$table->timestamp('email_verified_at')->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}