<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePasswordResetRequestsTable extends Migration {

	public function up()
	{
		Schema::create('password_reset_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('users_id')->unsigned()->nullable();
			$table->integer('admin_id')->unsigned()->nullable();
			$table->string('slug')->nullable();
			$table->text('motif')->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('password_reset_requests');
	}
}