<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('agency_id')->references('id')->on('agencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agencys', function(Blueprint $table) {
			$table->foreign('partner_id')->references('id')->on('partners')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agencys', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countrys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('agencys', function(Blueprint $table) {
			$table->foreign('default_currency_id')->references('id')->on('currencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('partners', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countrys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('partners', function(Blueprint $table) {
			$table->foreign('default_currency_id')->references('id')->on('currencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('countrys', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('intervals', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countrys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('intervals', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transfer_fees', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countrys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transfer_fees', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transfer_fees', function(Blueprint $table) {
			$table->foreign('interval_id')->references('id')->on('intervals')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->foreign('beneficiary_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->foreign('box_id')->references('id')->on('boxes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->foreign('sender_agency_id')->references('id')->on('agencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->foreign('beneficiary_agency_id')->references('id')->on('agencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->foreign('sender_customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->foreign('beneficiary_customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->foreign('beneficiary_country_id')->references('id')->on('countrys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->foreign('transfer_fee_id')->references('id')->on('transfer_fees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('exchange_fees', function(Blueprint $table) {
			$table->foreign('currency_in_id')->references('id')->on('currencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('exchange_fees', function(Blueprint $table) {
			$table->foreign('currency_out_id')->references('id')->on('currencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('exchanges', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('exchanges', function(Blueprint $table) {
			$table->foreign('box_id')->references('id')->on('boxes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('exchanges', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('exchanges', function(Blueprint $table) {
			$table->foreign('exchange_agency_id')->references('id')->on('agencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('exchanges', function(Blueprint $table) {
			$table->foreign('cashout_agency_id')->references('id')->on('agencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('exchanges', function(Blueprint $table) {
			$table->foreign('exchange_fee_id')->references('id')->on('exchange_fees')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('exchanges', function(Blueprint $table) {
			$table->foreign('country_withdrawal_id')->references('id')->on('countrys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('configs', function(Blueprint $table) {
			$table->foreign('default_currency_id')->references('id')->on('currencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('configs', function(Blueprint $table) {
			$table->foreign('default_country_id')->references('id')->on('countrys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('boxes', function(Blueprint $table) {
			$table->foreign('agency_id')->references('id')->on('agencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->foreign('box_id')->references('id')->on('boxes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->foreign('agency_id')->references('id')->on('agencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->foreign('partner_id')->references('id')->on('partners')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments_commissions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('payments_commissions', function(Blueprint $table) {
			$table->foreign('commission_id')->references('id')->on('commissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cashs', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cash_statements', function(Blueprint $table) {
			$table->foreign('user_box_id')->references('id')->on('users_box')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cash_statements', function(Blueprint $table) {
			$table->foreign('admin_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cash_statements', function(Blueprint $table) {
			$table->foreign('end_id')->references('id')->on('cash_statements')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('cash_statements', function(Blueprint $table) {
			$table->foreign('auditor_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cash_statements', function(Blueprint $table) {
			$table->foreign('sender_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cash_statements', function(Blueprint $table) {
			$table->foreign('beneficiary_user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cash_bands', function(Blueprint $table) {
			$table->foreign('cash_id')->references('id')->on('cashs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cash_bands', function(Blueprint $table) {
			$table->foreign('cash_statement_id')->references('id')->on('cash_statements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_box', function(Blueprint $table) {
			$table->foreign('box_id')->references('id')->on('boxes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users_box', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reloads_uv', function(Blueprint $table) {
			$table->foreign('users_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reloads_uv', function(Blueprint $table) {
			$table->foreign('agency_id')->references('id')->on('agencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reloads_uv', function(Blueprint $table) {
			$table->foreign('partner_id')->references('id')->on('partners')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reloads_uv', function(Blueprint $table) {
			$table->foreign('users_box_id')->references('id')->on('users_box')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reloads_uv', function(Blueprint $table) {
			$table->foreign('reloader_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('password_reset_requests', function(Blueprint $table) {
			$table->foreign('users_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('password_reset_requests', function(Blueprint $table) {
			$table->foreign('admin_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('amount_cash_statements_currencies', function(Blueprint $table) {
			$table->foreign('cash_statement_id')->references('id')->on('cash_statements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('amount_cash_statements_currencies', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('amount_cash_users_box_currencies', function(Blueprint $table) {
			$table->foreign('user_box_id')->references('id')->on('users_box')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('amount_cash_users_box_currencies', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('amount_cash_agencies_currencies', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('amount_cash_agencies_currencies', function(Blueprint $table) {
			$table->foreign('agency_id')->references('id')->on('agencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('amount_cash_partners_currencies', function(Blueprint $table) {
			$table->foreign('partner_id')->references('id')->on('partners')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('amount_cash_partners_currencies', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('amount_cash_users_currencies', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('amount_cash_users_currencies', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencys')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('audit_reports', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('audit_reports', function(Blueprint $table) {
			$table->foreign('cash_statement_id')->references('id')->on('cash_statements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_job_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_agency_id_foreign');
		});
		Schema::table('agencys', function(Blueprint $table) {
			$table->dropForeign('agencys_partner_id_foreign');
		});
		Schema::table('agencys', function(Blueprint $table) {
			$table->dropForeign('agencys_country_id_foreign');
		});
		Schema::table('agencys', function(Blueprint $table) {
			$table->dropForeign('agencys_default_currency_id_foreign');
		});
		Schema::table('partners', function(Blueprint $table) {
			$table->dropForeign('partners_country_id_foreign');
		});
		Schema::table('partners', function(Blueprint $table) {
			$table->dropForeign('partners_default_currency_id_foreign');
		});
		Schema::table('countrys', function(Blueprint $table) {
			$table->dropForeign('countrys_currency_id_foreign');
		});
		Schema::table('intervals', function(Blueprint $table) {
			$table->dropForeign('intervals_country_id_foreign');
		});
		Schema::table('intervals', function(Blueprint $table) {
			$table->dropForeign('intervals_currency_id_foreign');
		});
		Schema::table('transfer_fees', function(Blueprint $table) {
			$table->dropForeign('transfer_fees_country_id_foreign');
		});
		Schema::table('transfer_fees', function(Blueprint $table) {
			$table->dropForeign('transfer_fees_currency_id_foreign');
		});
		Schema::table('transfer_fees', function(Blueprint $table) {
			$table->dropForeign('transfer_fees_interval_id_foreign');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->dropForeign('transfers_user_id_foreign');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->dropForeign('transfers_beneficiary_user_id_foreign');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->dropForeign('transfers_box_id_foreign');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->dropForeign('transfers_sender_agency_id_foreign');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->dropForeign('transfers_beneficiary_agency_id_foreign');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->dropForeign('transfers_sender_customer_id_foreign');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->dropForeign('transfers_beneficiary_customer_id_foreign');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->dropForeign('transfers_beneficiary_country_id_foreign');
		});
		Schema::table('transfers', function(Blueprint $table) {
			$table->dropForeign('transfers_transfer_fee_id_foreign');
		});
		Schema::table('exchange_fees', function(Blueprint $table) {
			$table->dropForeign('exchange_fees_currency_in_id_foreign');
		});
		Schema::table('exchange_fees', function(Blueprint $table) {
			$table->dropForeign('exchange_fees_currency_out_id_foreign');
		});
		Schema::table('exchanges', function(Blueprint $table) {
			$table->dropForeign('exchanges_user_id_foreign');
		});
		Schema::table('exchanges', function(Blueprint $table) {
			$table->dropForeign('exchanges_box_id_foreign');
		});
		Schema::table('exchanges', function(Blueprint $table) {
			$table->dropForeign('exchanges_customer_id_foreign');
		});
		Schema::table('exchanges', function(Blueprint $table) {
			$table->dropForeign('exchanges_exchange_agency_id_foreign');
		});
		Schema::table('exchanges', function(Blueprint $table) {
			$table->dropForeign('exchanges_cashout_agency_id_foreign');
		});
		Schema::table('exchanges', function(Blueprint $table) {
			$table->dropForeign('exchanges_exchange_fee_id_foreign');
		});
		Schema::table('exchanges', function(Blueprint $table) {
			$table->dropForeign('exchanges_country_withdrawal_id_foreign');
		});
		Schema::table('configs', function(Blueprint $table) {
			$table->dropForeign('configs_default_currency_id_foreign');
		});
		Schema::table('configs', function(Blueprint $table) {
			$table->dropForeign('configs_default_country_id_foreign');
		});
		Schema::table('boxes', function(Blueprint $table) {
			$table->dropForeign('boxes_agency_id_foreign');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->dropForeign('commissions_box_id_foreign');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->dropForeign('commissions_user_id_foreign');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->dropForeign('commissions_agency_id_foreign');
		});
		Schema::table('commissions', function(Blueprint $table) {
			$table->dropForeign('commissions_partner_id_foreign');
		});
		Schema::table('payments_commissions', function(Blueprint $table) {
			$table->dropForeign('payments_commissions_user_id_foreign');
		});
		Schema::table('payments_commissions', function(Blueprint $table) {
			$table->dropForeign('payments_commissions_commission_id_foreign');
		});
		Schema::table('cashs', function(Blueprint $table) {
			$table->dropForeign('cashs_currency_id_foreign');
		});
		Schema::table('cash_statements', function(Blueprint $table) {
			$table->dropForeign('cash_statements_user_box_id_foreign');
		});
		Schema::table('cash_statements', function(Blueprint $table) {
			$table->dropForeign('cash_statements_admin_id_foreign');
		});
		Schema::table('cash_statements', function(Blueprint $table) {
			$table->dropForeign('cash_statements_end_id_foreign');
		});
		Schema::table('cash_statements', function(Blueprint $table) {
			$table->dropForeign('cash_statements_auditor_user_id_foreign');
		});
		Schema::table('cash_statements', function(Blueprint $table) {
			$table->dropForeign('cash_statements_sender_user_id_foreign');
		});
		Schema::table('cash_statements', function(Blueprint $table) {
			$table->dropForeign('cash_statements_beneficiary_user_id_foreign');
		});
		Schema::table('cash_bands', function(Blueprint $table) {
			$table->dropForeign('cash_bands_cash_id_foreign');
		});
		Schema::table('cash_bands', function(Blueprint $table) {
			$table->dropForeign('cash_bands_cash_statement_id_foreign');
		});
		Schema::table('users_box', function(Blueprint $table) {
			$table->dropForeign('users_box_box_id_foreign');
		});
		Schema::table('users_box', function(Blueprint $table) {
			$table->dropForeign('users_box_user_id_foreign');
		});
		Schema::table('reloads_uv', function(Blueprint $table) {
			$table->dropForeign('reloads_uv_users_id_foreign');
		});
		Schema::table('reloads_uv', function(Blueprint $table) {
			$table->dropForeign('reloads_uv_agency_id_foreign');
		});
		Schema::table('reloads_uv', function(Blueprint $table) {
			$table->dropForeign('reloads_uv_partner_id_foreign');
		});
		Schema::table('reloads_uv', function(Blueprint $table) {
			$table->dropForeign('reloads_uv_users_box_id_foreign');
		});
		Schema::table('reloads_uv', function(Blueprint $table) {
			$table->dropForeign('reloads_uv_reloader_id_foreign');
		});
		Schema::table('password_reset_requests', function(Blueprint $table) {
			$table->dropForeign('password_reset_requests_users_id_foreign');
		});
		Schema::table('password_reset_requests', function(Blueprint $table) {
			$table->dropForeign('password_reset_requests_admin_id_foreign');
		});
		Schema::table('amount_cash_statements_currencies', function(Blueprint $table) {
			$table->dropForeign('amount_cash_statements_currencies_cash_statement_id_foreign');
		});
		Schema::table('amount_cash_statements_currencies', function(Blueprint $table) {
			$table->dropForeign('amount_cash_statements_currencies_currency_id_foreign');
		});
		Schema::table('amount_cash_users_box_currencies', function(Blueprint $table) {
			$table->dropForeign('amount_cash_users_box_currencies_user_box_id_foreign');
		});
		Schema::table('amount_cash_users_box_currencies', function(Blueprint $table) {
			$table->dropForeign('amount_cash_users_box_currencies_currency_id_foreign');
		});
		Schema::table('amount_cash_agencies_currencies', function(Blueprint $table) {
			$table->dropForeign('amount_cash_agencies_currencies_currency_id_foreign');
		});
		Schema::table('amount_cash_agencies_currencies', function(Blueprint $table) {
			$table->dropForeign('amount_cash_agencies_currencies_agency_id_foreign');
		});
		Schema::table('amount_cash_partners_currencies', function(Blueprint $table) {
			$table->dropForeign('amount_cash_partners_currencies_partner_id_foreign');
		});
		Schema::table('amount_cash_partners_currencies', function(Blueprint $table) {
			$table->dropForeign('amount_cash_partners_currencies_currency_id_foreign');
		});
		Schema::table('amount_cash_users_currencies', function(Blueprint $table) {
			$table->dropForeign('amount_cash_users_currencies_user_id_foreign');
		});
		Schema::table('amount_cash_users_currencies', function(Blueprint $table) {
			$table->dropForeign('amount_cash_users_currencies_currency_id_foreign');
		});
		Schema::table('audit_reports', function(Blueprint $table) {
			$table->dropForeign('audit_reports_user_id_foreign');
		});
		Schema::table('audit_reports', function(Blueprint $table) {
			$table->dropForeign('audit_reports_cash_statement_id_foreign');
		});
	}
}