<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('store_id')->unsigned();
			$table->decimal('cash', 10,2);
			$table->integer('point');
			$table->decimal('commission', 10,2);
			$table->integer('order_number');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}