<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackagesTable extends Migration {

	public function up()
	{
		Schema::create('packages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('desc')->nullable();
			$table->string('type');
			$table->string('price');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('admin_id');
			$table->string('created_by');
			$table->string('updated_by');
		});
	}

	public function down()
	{
		Schema::drop('packages');
	}
}