<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('workplace_id')->references('id')->on('workspaces')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('expertis_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('expertis_user', function(Blueprint $table) {
			$table->foreign('expert_id')->references('id')->on('expertise')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('devices', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('profile', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_packages', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_packages', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_workplace_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_package_id_foreign');
		});
		Schema::table('expertis_user', function(Blueprint $table) {
			$table->dropForeign('expertis_user_user_id_foreign');
		});
		Schema::table('expertis_user', function(Blueprint $table) {
			$table->dropForeign('expertis_user_expert_id_foreign');
		});
		Schema::table('devices', function(Blueprint $table) {
			$table->dropForeign('devices_user_id_foreign');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->dropForeign('packages_user_id_foreign');
		});
		Schema::table('profile', function(Blueprint $table) {
			$table->dropForeign('profile_user_id_foreign');
		});
		Schema::table('user_packages', function(Blueprint $table) {
			$table->dropForeign('user_packages_package_id_foreign');
		});
		Schema::table('user_packages', function(Blueprint $table) {
			$table->dropForeign('user_packages_user_id_foreign');
		});
	}
}