<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorInfosTable extends Migration {

	public function up()
	{
		Schema::create('doctor_infos', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned();
			$table->string('title');
			$table->string('nationality');
			$table->string('country_of_residence');
			$table->string('fluent_language');
			$table->string('highest_degree');
			$table->string('university');
			$table->string('graduation_year');
			$table->string('classification');
			$table->string('specification');
			$table->string('number_of_years_of_experience');
			$table->string('licensing_area');
			$table->string('licensing_number');
			$table->boolean('work_on_clinic');
			$table->string('clinic_address')->nullable();
			$table->boolean('has_more_than_one_qualification');
			$table->string('qualifications')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('doctor_infos');
	}
}