<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesDetailsTable extends Migration {

	public function up()
	{
		Schema::create('companies_details', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('company_id')->unsigned();
			$table->string('commercial_lines', 122)->unique();
			$table->string('commercial_lines_file', 122);
			$table->string('taxes_licenses', 122);
			$table->string('taxes_icenses_file', 122);
			$table->date('started_date');
			$table->string('brief', 657);
			$table->string('company_profile', 122);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('companies_details');
	}
}