<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 122)->unique();
			$table->string('img', 122);
			$table->string('mobile', 20)->unique();
			$table->string('email', 122)->unique();
			$table->string('password', 122);
			$table->string('logo', 122);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}