<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAgeCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('age_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255)->nullable();
			$table->integer('age_from')->nullable();
			$table->integer('age_to')->nullable();
			$table->char('status', 1)->default('1');
		});
	}

	public function down()
	{
		Schema::drop('age_categories');
	}
}