<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFlDetailsTable extends Migration {

	public function up()
	{
		Schema::create('fl_details', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('fl_users_id')->unsigned()->nullable();
			$table->text('overview')->nullable();
			$table->longText('description')->nullable();
			$table->text('education')->nullable();
			$table->char('voice_gender', 1)->default('M');
			$table->integer('age_category_id')->unsigned();
			$table->integer('language_id')->unsigned();
			$table->integer('accent_id')->unsigned();
			$table->string('average_work_hours', 255)->nullable();
			$table->text('microphone_details')->nullable();
			$table->text('computer_hardware_software')->nullable();
			$table->text('special_equipment')->nullable();
			$table->integer('experience_level_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('fl_details');
	}
}