<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFlPersonalInfosTable extends Migration {

	public function up()
	{
		Schema::create('fl_personal_infos', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('fl_users_id')->unsigned()->nullable();
			$table->string('name', 255)->nullable();
			$table->string('profile_photo', 255)->nullable();
			$table->string('gender', 6)->nullable();
			$table->string('state', 255)->nullable();
			$table->string('city', 255)->nullable();
			$table->mediumText('address')->nullable();
			$table->string('pin', 6)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('fl_personal_infos');
	}
}