<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReInfosTable extends Migration {

	public function up()
	{
		Schema::create('re_infos', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('re_user_id')->unsigned()->nullable();
			$table->string('name', 255)->nullable();
			$table->string('state', 255)->nullable();
			$table->string('city', 255)->nullable();
			$table->text('address')->nullable();
			$table->string('pin', 10)->nullable();
			$table->string('gst', 20)->nullable();
			$table->string('pan', 20)->nullable();
			$table->text('description')->nullable();
			$table->text('reason_of_hire')->nullable();
			$table->string('web_url')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('re_infos');
	}
}