<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Accent extends Eloquent {

	protected $table = 'accents';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'status');

	public function job()
	{
		return $this->hasMany('App\Models\Job');
	}

	public function freelanceDetails()
	{
		return $this->hasMany('App\Models\FreelanceDetails');
	}

}