<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FreelanceUsers extends Eloquent {

	protected $table = 'fl_users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('mobile', 'email', 'otp', 'status');
	protected $hidden = array('password');

	public function previousExperience()
	{
		return $this->hasMany('App\Models\FreelancePreviousExperience');
	}

}