<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class RecruiterInfo extends Eloquent {

	protected $table = 're_infos';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('re_user_id', 'name', 'state', 'city', 'address', 'pin', 'gst', 'pan', 'description', 'reason_of_hire', 'web_url');

	public function recruiterUser()
	{
		return $this->belongsTo('App\Models\RecruiterUser', 're_user_id');
	}

}