<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTanksTable extends Migration {

	public function up()
	{
		Schema::create('tanks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('abacus');
			$table->float('diameter')->nullable();
			$table->string('liquid_type')->nullable();
			$table->string('file_path')->nullable();
			$table->float('man_hole_height');
			$table->float('sensor_depth')->nullable();
			$table->string('sensor_reference')->nullable();
			$table->float('level_active_depotage')->nullable();
			$table->integer('product_station_tank_id')->unsigned();
			$table->integer('jauge_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('tanks');
	}
}