<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServiceStationsTable extends Migration {

	public function up()
	{
		Schema::create('service_stations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('description')->nullable();
			$table->integer('town_id')->unsigned();
			$table->string('latitude')->nullable();
			$table->string('longitude')->nullable();
			$table->boolean('status')->default(true);
			$table->string('back_image_link')->nullable();
			$table->string('address')->nullable();
			$table->string('gmt')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('service_stations');
	}
}