<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWithdrawalTable extends Migration {

	public function up()
	{
		Schema::create('withdrawal', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->timestamps();
			$table->double('amount')->nullable();
			$table->bigInteger('vendor_id')->nullable();
			$table->tinyInteger('method')->default('1');
			$table->bigInteger('customer_id')->nullable();
			$table->text('description')->nullable();
			$table->string('extra1')->nullable();
			$table->string('extra2')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('withdrawal');
	}
}