<?php

namespace App\Models\Involvements;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Involvement extends Eloquent {

	protected $table = 'involvements';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function getEpisodeTypes()
	{
		return $this->belongsToMany('EpisodeType', 'episode_type_involvement');
	}

	public function getEventFacts()
	{
		return $this->belongsToMany('Events', 'event_facts_involvement');
	}

	public function getChallenges()
	{
		return $this->belongsToMany('Challenge', 'challenge_involvement');
	}

	public function getQuizes()
	{
		return $this->hasMany('Quiz');
	}

	public function getActivities()
	{
		return $this->hasMany('Activity');
	}

}