<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateManagersTable extends Migration {

	public function up()
	{
		Schema::create('managers', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('branch_id')->unsigned()->index();
			$table->string('name', 32)->nullable();
			$table->string('email')->unique();
			$table->integer('code')->unique();
			$table->string('password')->nullable();
			$table->boolean('status')->default(false);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('managers');
	}
}