<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchInventoryIngredientsTable extends Migration {

	public function up()
	{
		Schema::create('branch_inventory_ingredients', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('branch_inventory_id')->unsigned()->index();
			$table->bigInteger('ingredient_id')->unsigned()->index();
			$table->bigInteger('measuring_unit_id')->unsigned()->index();
			$table->decimal('value')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('branch_inventory_ingredients');
	}
}