<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePicturesTable extends Migration {

	public function up()
	{
		Schema::create('pictures', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('picture');
			$table->integer('width')->nullable();
			$table->integer('height')->nullable();
			$table->integer('size')->nullable();
			$table->string('thumbnail', 64)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('pictures');
	}
}