<?php

namespace App/models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Courtier extends Model 
{

    protected $table = 'Courtier';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('taux_commission');

    public function ventes()
    {
        return $this->hasMany('Vente');
    }

    public function user()
    {
        return $this->morphOne('User', 'profile');
    }

}