<?php

namespace App/models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vente extends Model 
{

    protected $table = 'Ventes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('montant');

    public function bienimmobiliere()
    {
        return $this->belongsTo('BienImmobilieres');
    }

    public function utilisateur()
    {
        return $this->belongsTo('User');
    }

}