<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('item')->references('id')->on('items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('pricelist_items', function(Blueprint $table) {
			$table->foreign('pricelist')->references('id')->on('pricelists')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_item_foreign');
		});
		Schema::table('pricelist_items', function(Blueprint $table) {
			$table->dropForeign('pricelist_items_pricelist_foreign');
		});
	}
}