<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateComplaintsTable extends Migration {

	public function up()
	{
		Schema::create('complaints', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('advert_id')->unsigned();
			$table->longText('details');
			$table->bigInteger('user_id')->unsigned();
			$table->boolean('admin_seen')->default(false);
			$table->text('admin_replay');
		});
	}

	public function down()
	{
		Schema::drop('complaints');
	}
}