<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Rating extends Eloquent {

	protected $table = 'ratings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function ratingable()
	{
		return $this->morphTo();
	}

}