<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdvertsTable extends Migration {

	public function up()
	{
		Schema::create('adverts', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned();
			$table->text('name');
			$table->text('description')->nullable();
			$table->bigInteger('category_id')->unsigned();
			$table->decimal('price')->default('0');
			$table->decimal('age')->default('0');
			$table->string('phone', 20);
			$table->boolean('show_phone')->default(false);
			$table->bigInteger('health_conditions_id')->unsigned();
			$table->bigInteger('region_id')->unsigned();
			$table->bigInteger('city_id')->unsigned();
			$table->bigInteger('district_id')->unsigned();
			$table->decimal('lat');
			$table->decimal('lng');
			$table->bigInteger('package_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('adverts');
	}
}