<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Advert extends Eloquent {

	protected $table = 'adverts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function category()
	{
		return $this->belongsTo('Category');
	}

	public function subCategory()
	{
		return $this->belongsTo('Category');
	}

	public function healthCondition()
	{
		return $this->belongsTo('HealthCondition');
	}

	public function region()
	{
		return $this->belongsTo('Region');
	}

	public function city()
	{
		return $this->belongsTo('City');
	}

	public function district()
	{
		return $this->belongsTo('District');
	}

	public function attatchments()
	{
		return $this->hasMany('AdvertAttachment');
	}

	public function favorites()
	{
		return $this->hasMany('Favourite');
	}

	public function follows()
	{
		return $this->morphMany('Follow');
	}

	public function complaints()
	{
		return $this->hasMany('Complaint');
	}

	public function ratings()
	{
		return $this->morphMany('Rating');
	}

}