<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Chat extends Eloquent {

	protected $table = 'chats';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function messages()
	{
		return $this->hasMany('Message');
	}

	public function user1()
	{
		return $this->belongsTo('User');
	}

	public function user2()
	{
		return $this->belongsTo('User');
	}

	public function advert()
	{
		return $this->belongsTo('Advert');
	}

}